<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Auto_Featured_Image {

    public function __construct() {
        // Constructor is empty as we've integrated settings into the main plugin
    }

    public function afi_set_featured_image($post_id, $post) {
        $option = get_option('afi_auto_featured_image', 'none');

        if ($post->post_type !== 'post') {
            return; // Only apply to posts.
        }

        if ($option === 'none') {
            return;
        }

        if ($option === 'draft' && get_post_status($post_id) !== 'draft') {
            return;
        }

        if ($option === 'publish' && get_post_status($post_id) !== 'publish') {
            return;
        }

        if ($option === 'both' && !in_array(get_post_status($post_id), array('draft', 'publish'))) {
            return;
        }

        if (wp_is_post_revision($post_id) || !empty(get_post_thumbnail_id($post_id))) {
            return;
        }

        // Ensure we have a title before setting the featured image
        if (empty($post->post_title)) {
            return;
        }

        $this->set_featured_image_from_file($post_id);
    }

    public function set_featured_image_from_file($post_id) {
        $image_urls = array(
            'https://media.istockphoto.com/id/868054620/photo/image-of-open-antique-book-on-wooden-table-with-glitter-background.jpg?s=612x612&w=0&k=20&c=mOSTivi-JE4naGotn-cOtqC32oPxIfL_VU-bCkvfBJk=',
		'https://media.istockphoto.com/id/1440037269/photo/closeup-shot-of-a-child-holding-an-open-bible-while-looking-at-it-with-a-blurred-background.jpg?s=612x612&w=0&k=20&c=o2uMUeLM2sTR-pSQMf20DI_cj9MfGT861-N5KCMqCms=',
		'https://media.istockphoto.com/id/1425240532/photo/church-evangelism-concept-that-delivers-the-holy-bible-and-the-gospel-of-jesus-christ.jpg?s=612x612&w=0&k=20&c=I6kkxSfcA1KnbBqSA30EE0pnrYs8KgizOYfWwA_DqSk=',
		'https://media.istockphoto.com/id/1420207987/photo/hand-holding-bible-up-to-the-sun-light.jpg?s=612x612&w=0&k=20&c=ZII0w9fTsCFSsKNxeuRw9J8EdPHgPInTB0yofsZH6Zg=',
        'https://cdn.pixabay.com/photo/2023/08/15/21/03/cross-8192852_1280.jpg',
		'https://media.istockphoto.com/id/177861091/photo/couple-reading-the-bible-by-a-lake.jpg?s=612x612&w=0&k=20&c=lJZqtTtKKyR6VjKVNEtbrKJ3R_cUarh8_fWHfZEWs4U=',
		'https://media.istockphoto.com/id/623522238/photo/bible-and-cross-on-desk.jpg?s=612x612&w=0&k=20&c=hJn2iRceeD31iBDXZLthwNcsGk37adbDNqkYZrLk24I=',
		'https://media.istockphoto.com/id/1874239008/photo/silhouetted-cross-atop-a-hill-at-sunset-religious-iconography.jpg?s=612x612&w=0&k=20&c=UMx33hrzDcZmvp4wIYWc9pLsqHgAqBF1eoklPLwcpCg=',
		'https://media.istockphoto.com/id/2150108294/photo/flower-petals-blowing-in-the-spring-wind-white-cherry-blossom-trees-the-holy-bible-religion.jpg?s=612x612&w=0&k=20&c=H87FZVHr3Gnrd7QDFZa20MqJ9wNhfabejSyIUpqHzB0=',
		'https://media.istockphoto.com/id/1095076328/photo/beautiful-woman-praying-having-the-bible-opened-in-front-of-he.jpg?s=612x612&w=0&k=20&c=qvGCrUAkpRTflSpKe1bZ_-jsFeOsdkbY19qqLd2vCWI=',
		'https://cdn.pixabay.com/photo/2024/05/10/21/43/cross-8753732_640.jpg',
		'https://media.istockphoto.com/id/921871490/photo/woman-holding-an-open-book-bursting-with-light.jpg?s=612x612&w=0&k=20&c=qCLFE3aE8PIvPq8DCRW7LFVyEnWHVtqpvQcNyTDKUb4=',
		'https://media.istockphoto.com/id/1166794034/photo/reading-the-holy-bible-in-outdoors-christian-girl-holds-bible-in-her-hands-sitting-on-a-bench.jpg?s=612x612&w=0&k=20&c=vdJ-zBRbPFl2bV6y28OtLGwRoIUnFwstqWQdToS2FOI=',
		'https://media.istockphoto.com/id/1644394296/photo/woman-holding-a-bible-a-natural-field.jpg?s=612x612&w=0&k=20&c=IUik9uTOETqHtrUVLOfscKvN4Gi0BQet38IOHVYHuuc=',
		'https://media.istockphoto.com/id/982133688/photo/studying-the-words-of-the-god.jpg?s=612x612&w=0&k=20&c=8bVoTdJFnV2v-s8Fqpg6GfSmPQaHwIDkBK2KfPSm18M=',
		'https://media.istockphoto.com/id/1273278713/photo/silhouette-cross-and-birds-flying-on-sunrise-background.jpg?s=612x612&w=0&k=20&c=Lyc48HkP7cI5KwLGbbuNKyh8lQM2MOqU0viIHkl5xyw=',
		'https://media.istockphoto.com/id/1390618057/photo/two-lovers-studying-the-bible-it-is-gods-love-for-christians.jpg?s=612x612&w=0&k=20&c=6O2opn6fQANNOIZkXV98zr0uUrxo4oF4pJLjTJO0tqc=',
		'https://cdn.pixabay.com/photo/2022/02/16/14/47/chapel-7016933_640.jpg',
		'https://media.istockphoto.com/id/1408186534/photo/a-child-reading-a-bible-and-a-cross-in-the-sunset-sky.jpg?s=612x612&w=0&k=20&c=eLegIxWaUem9IKHZYMRX83LFAA6gvRPMf_78G9mhlWI=',
		'https://cdn.pixabay.com/photo/2018/02/13/00/11/jesus-3149505_640.png',
		'https://media.istockphoto.com/id/1138582169/photo/christian-woman-praying-worship-at-sunset-hands-folded-in-prayer-worship-god-with-christian.jpg?s=612x612&w=0&k=20&c=yHepQ_m99c76XRdZEVfO7IDJc8m2Pcv8TN8pT4lo2Gg=',
		'https://media.istockphoto.com/id/895282970/photo/the-cross-sundown.jpg?s=612x612&w=0&k=20&c=jvxKUI-A1Qe_4skFF3iDMZBgtkJeybJPaemneaDOKqQ=',
		'https://media.istockphoto.com/id/1077031408/photo/happy-woman-reading.jpg?s=612x612&w=0&k=20&c=pPCQql11_nf4F1TXk3fsTkpM4iS53uwiwS_tp1B8WiI=',
		'https://media.istockphoto.com/id/1402653381/photo/man-reading-bible-by-lake-in-the-morning.jpg?s=612x612&w=0&k=20&c=zIUEHNr2nowYMxPqbv7S8Hvpvsu3QlaCDsZxp4CJL-4=',
		'https://media.istockphoto.com/id/678510440/photo/going-through-his-daily-devotions.jpg?s=612x612&w=0&k=20&c=yIwgligXGHmhXHdjgPpQimtfbDIbWp6OyqvYb_qZVq4=',
		'https://media.istockphoto.com/id/1088842034/photo/woman-holding-reading-bible-on-mountain-in-the-morning-image.jpg?s=612x612&w=0&k=20&c=nkfadGaXqCsS2Ddo_2gGEWI43iXMdkfsSa81mdy-fao=',
		'https://media.istockphoto.com/id/1403423688/photo/christian-man-holding-the-holy-bible-at-sunset-by-water-and-field-background.jpg?s=612x612&w=0&k=20&c=O7eEYuV45kWg_w08nkuB4TBRTHK-qD14L7BsW6P16_Q=',
		'https://media.istockphoto.com/id/1201194519/photo/white-pigeons-fly-out-of-books-that-are-flicked-by-the-wind-in-beautiful-light-on-sunset.jpg?s=612x612&w=0&k=20&c=JGvFmpjSWvUYPxa713dUJuXrFfz9gVGhIUdEL9UROeM=',
		'https://media.istockphoto.com/id/1341060834/photo/close-up-of-mans-hands-while-reading-the-bible-outside-sunday-readings-bible-education.jpg?s=612x612&w=0&k=20&c=0VHLTLC06wwU2mGx4hOUS05RS57a0Cyx_q4xtCrSuSY=',
		'https://media.istockphoto.com/id/683912118/photo/cute-asian-little-girl-closed-her-eyes-and-folded-her-hand-in-prayer-on-a-holy-bible.jpg?s=612x612&w=0&k=20&c=s8w7ti5TZSdW3vHgqPPANv6YxirbMi0RShc4UnJXlms=',
		'https://cdn.pixabay.com/photo/2024/04/02/23/47/lake-8671868_640.jpg',
		
		'https://media.istockphoto.com/id/825780904/photo/the-cross.jpg?s=612x612&w=0&k=20&c=DZJnlcPZ8TOx9aNsKhpcTDGrw2fK8y4W8hDDfltXG84=',
		'https://media.istockphoto.com/id/695858178/photo/light-coming-from-book-in-woman-39-s-hands-in-gesture-of-giving.jpg?s=612x612&w=0&k=20&c=mHOBVZsDzyddqJr-l7rhde9MQnuyfoCFL97IiRSzHAY=',
		'https://media.istockphoto.com/id/1210232039/photo/mature-african-american-woman-sitting-outside-reading.jpg?s=612x612&w=0&k=20&c=56ydij9EWcH8p4emE7Ak5W7vazrywBEpdx7CxTpO1Ik=',
		'https://media.istockphoto.com/id/1316556845/photo/man-sitting-while-reading-bible-or-book-over-concrete-wall-with-window-light.jpg?s=612x612&w=0&k=20&c=f3FYZqlovp3LbPpJXYDx_9EesXc2dTLzUdBDlPwqWR0=',
		'https://media.istockphoto.com/id/1353676019/photo/winner-woman-holding-bible-in-the-sky.jpg?s=612x612&w=0&k=20&c=buR9Xs7NLkUyCFx8vWZZJM-PLWuOe2zEpw3w-Goo0K0=',
		'https://media.istockphoto.com/id/1411701868/photo/magic-book-with-glitter-open-book-with-lights-glowing-in-dark-background.jpg?s=612x612&w=0&k=20&c=-vGSj8f8tj6Zbj2mDZCABgP50rcLjqWw-KwxgDA2cYc=',
		'https://media.istockphoto.com/id/1440013745/photo/young-african-american-male-sitting-with-closed-eyes-with-the-bible-in-his-hands.jpg?s=612x612&w=0&k=20&c=x0XfMSBKjuMwngkKwvrIlHAEOcIPiREqA5hHBBGZKkQ=',
		'https://cdn.pixabay.com/photo/2021/10/19/09/31/summit-cross-6723088_640.jpg',
		'https://media.istockphoto.com/id/182188155/photo/hand-holding-bible.jpg?s=612x612&w=0&k=20&c=CS4BDtCbIOyrx0rXU84bV_6brayKQD3yKVimBKumQo8=',
		'https://media.istockphoto.com/id/1023227352/photo/silhouette-christian-cross-on-grass-at-sunrise-background-with-miracle-bright-lighting.jpg?s=612x612&w=0&k=20&c=YX2emv9cJ-BB3O1owerkNn2NFzglS-5xjsCBdCSYHVQ=',
		'https://media.istockphoto.com/id/505995404/photo/book.jpg?s=612x612&w=0&k=20&c=-DXJnY9-4yLzlgLU3tldGcNldjibg4HGT1Mfltkzl1U=',
		'https://media.istockphoto.com/id/528061326/photo/reading-the-bible-together.jpg?s=612x612&w=0&k=20&c=tum7rZL47qjHIk2nQLD04pA3fDyp9wLTHrQC9CJSq8Y=',
		'https://media.istockphoto.com/id/182507097/photo/young-man-holding-a-bible.jpg?s=612x612&w=0&k=20&c=t3bd1VxNZbzHdlIbgdWKFY9cHs3h1YYOuuUPqQ7OmPA=',
		'https://media.istockphoto.com/id/1294989363/photo/opening-book-of-holy-bible-with-text-on-blurred-cross-background.jpg?s=612x612&w=0&k=20&c=QBnff1j14tV0qDTecc_I2bbR8lo95cGRPEAdl7P08Es=',
		'https://media.istockphoto.com/id/1452440885/photo/christian-couple-or-group-reading-study-the-bible-together-and-pray-at-a-home-or-sunday.jpg?s=612x612&w=0&k=20&c=1cqunYiLiM3XaFb2a9EtaAKfp0GuW4rRzxb1IsG4fkU=',
		'https://media.istockphoto.com/id/1038860040/photo/a-bible-on-the-table-in-the-light-of-a-candle.jpg?s=612x612&w=0&k=20&c=nslr7hPV-bW6ABdPfQxccTh0PqyCDfxrP_-9bToK2-I=',
		'https://media.istockphoto.com/id/1414832136/photo/the-woman-sitting-readings-bible-a-holy-bible-for-faith-spirituality-with-the-sunlight-in-the.jpg?s=612x612&w=0&k=20&c=wFmQclXflxJGdUyufsTqnRWt-XOFlThWrl_NlnP76x0=',
		'https://media.istockphoto.com/id/1389100354/photo/the-cross-of-jesus-christ-shining-in-the-rainbow-sky-and-clouds-sunlight.jpg?s=612x612&w=0&k=20&c=OhIAiRFh859gWYwiam-3THNrBYrfuTxPr2BAABA-iI4=',
		'https://media.istockphoto.com/id/1440030109/photo/close-shot-of-holy-bible-on-a-wooden-surface-with-the-sun-shining-in-the-background.jpg?s=612x612&w=0&k=20&c=ijHrw26I-mTcZi9YJEfjD72VurwkCni5kzRsoyQSPdQ=',
		'https://media.istockphoto.com/id/1412587713/photo/close-up-of-christian-mans-hands-while-reading-the-bible-outside-sunday-readings-bible.jpg?s=612x612&w=0&k=20&c=2cctr1HVfE8_zwL3QYnwKIZQi2vYlfLKKaCUWWgaTJo=',
		'https://media.istockphoto.com/id/1774027958/photo/girl-with-a-bible-in-her-hands-christian-concept.jpg?s=612x612&w=0&k=20&c=NnOcohd6aFKUGEtb48Of3iHVRB7Yn7CdL9PKQMVs6UI=',
		'https://media.istockphoto.com/id/476805512/photo/happy-mature-couple-with-book.jpg?s=612x612&w=0&k=20&c=Vrb-RXuHd1_jPwfsZoz2knCys9oo58KSwkuJ9gmOABg=',
		'https://media.istockphoto.com/id/1675387133/photo/a-easter-cross-on-the-dawn-background.jpg?s=612x612&w=0&k=20&c=dpsjr0CCgQ99qHQMVdaWyTiWY9PjMhdaDSUC_a8SvP0=',
		'https://media.istockphoto.com/id/683911536/photo/mother-and-little-girl-hands-folded-in-prayer-on-a-holy-bible-together.jpg?s=612x612&w=0&k=20&c=kCLxRwCH7PAmdPMPhh6_SFeoSnzGyBfjiB-52Ic6nTM=',
		'https://media.istockphoto.com/id/1252284937/photo/bible-and-wood-holy-cross.jpg?s=612x612&w=0&k=20&c=FTtJasHs1JYV1WQiq2jDUQQoRbD76FROgHUzZ9LAmO8=',
		'https://media.istockphoto.com/id/1308622991/photo/cross-at-sunset-religion-and-faith.jpg?s=612x612&w=0&k=20&c=klBAv8XSSrzMEWwopkirBToogHpdDDIAgysmXJmpHoQ=',
		'https://media.istockphoto.com/id/1041747490/photo/this-ones-my-favourite.jpg?s=612x612&w=0&k=20&c=uBLdp60945UJuqwviqJsdowPy161fsJkMuoQSVw0AjU=',
		'https://media.istockphoto.com/id/1041747484/photo/meditating-on-gods-word.jpg?s=612x612&w=0&k=20&c=7ZZGhXYeYYX7_qFcysbx1NP6_FjjdLV9ZXELhTyTMnc=',
		'https://media.istockphoto.com/id/124657209/photo/holy-bible.jpg?s=612x612&w=0&k=20&c=9DUFwN7r-OS4i_r4Gubi03cKqbVQLkM7dBAbtIPHEDU=',
		'https://media.istockphoto.com/id/182417337/photo/holding-a-bible.jpg?s=612x612&w=0&k=20&c=-_BuypBSS8mbDcCb-7o-EvPCjxhsPM7XAgHn6Y8saic=',
		'https://media.istockphoto.com/id/1278481098/photo/good-friday-concept.jpg?s=612x612&w=0&k=20&c=sR7CucQRhb0ZnRCK_Dia2wjC2mP4xUV5oEbpNrsZFnQ=',
		'https://media.istockphoto.com/id/901488612/photo/senior-woman-with-bible.jpg?s=612x612&w=0&k=20&c=UjZxo2oadfq3cYwsNQVviVHgV8Flszs_UAZJLRKX8ao=',
		'https://cdn.pixabay.com/photo/2020/10/14/07/02/cross-5653453_640.jpg',
		'https://media.istockphoto.com/id/1133572107/photo/women-reading-the-holy-bible-reading-abook.jpg?s=612x612&w=0&k=20&c=5oRsRMYno1eW6KaUAlFVcqoVdjbQIJKI6Zod4hsH8E8=',
		'https://cdn.pixabay.com/photo/2023/04/03/17/30/jesus-church-7897365_640.jpg',
		'https://media.istockphoto.com/id/540573358/photo/men-praying-to-god.jpg?s=612x612&w=0&k=20&c=5Ug87Bd4h3TAlJNL7kfzt3_AWmIfyqx8vekWi6c5hXA=',
		'https://media.istockphoto.com/id/1399677386/photo/mature-african-american-woman-sitting-outside-reading.jpg?s=612x612&w=0&k=20&c=sInLqjWCNeFgtLerST0BAIx6n8-frpmuZApcC5xdwC0=',
		'https://media.istockphoto.com/id/481412780/photo/open-bible.jpg?s=612x612&w=0&k=20&c=vkck9LuK6LFJopfbua3k8CIGGcHUE3K_7ryLUn3H6wo=',
		'https://media.istockphoto.com/id/108350425/photo/man-offering-knowledge.jpg?s=612x612&w=0&k=20&c=b0Tq939FWS6Dbkb_4Q9YuXU6ChG9OPBJTX3nnk4e9-o=',
		'https://media.istockphoto.com/id/1156910546/photo/bible.jpg?s=612x612&w=0&k=20&c=8vaS4iFLyCh2N2cja3b8ZVhIoOqYjlnnFjcYYtiXV9w=',
		'https://media.istockphoto.com/id/1244894999/photo/mother-and-her-daughter-reading-from-bible-and-praying-in-their-knees-near-the-bed.jpg?s=612x612&w=0&k=20&c=11hmPRtgMb8Bi7MYLuYGfJDSnt-LS3kenGtt8v8xf6k=',
		'https://media.istockphoto.com/id/1429894635/photo/good-friday-concept-cross-on-sky-background.jpg?s=612x612&w=0&k=20&c=_x8E2NHi8RmqHyGmj0Ba8__mrFimBww1pEGxQ9XFAgk=',
		'https://media.istockphoto.com/id/1356562074/photo/christian-woman-holds-bible-in-her-hands-reading-the-holy-bible-on-the-sea-during-beautiful.jpg?s=612x612&w=0&k=20&c=QokkYXnsTIQeXZ2QKFibMsCM-4fu5txgMKC8OKtC7xc=',
		'https://media.istockphoto.com/id/1408186546/photo/bright-sunlight-bible-and-holy-crucifixion-of-jesus-christ.jpg?s=612x612&w=0&k=20&c=OXak34etzXDVHLIhcqIlFpx1IENlUBOAhj6QyN0ulyE=',
		'https://media.istockphoto.com/id/1063469726/photo/autumn-setting-warm-colours-girl-reading-the-bible.jpg?s=612x612&w=0&k=20&c=jq1m2nohTdg8nQwtsZdjFkfcIMulyQOwkWP2EGILmEI=',
		'https://media.istockphoto.com/id/635718292/photo/man-reading-a-book.jpg?s=612x612&w=0&k=20&c=oIDUd3c3cx8xNoeHsZXx03eY001JtPRr-kibQpEVQYo=',
		'https://media.istockphoto.com/id/1463986810/photo/christian-cross-on-hill-outdoors-at-sunrise.jpg?s=612x612&w=0&k=20&c=Hg8AwdbEcGgBLzP7nsXcpEw031eiI-a11PTjV0QnX48=',
		'https://cdn.pixabay.com/photo/2021/04/25/08/48/lake-6205925_640.jpg',
		'https://media.istockphoto.com/id/172435488/photo/king-james-bible.jpg?s=612x612&w=0&k=20&c=gt0kUp7VVXfuBLIMMf9SFYpECrUzIBw8ak2wQOat7aI=',
		'https://media.istockphoto.com/id/157615431/photo/woman-reading-bible.jpg?s=612x612&w=0&k=20&c=X85vii03-dZwREcYGLSCZaVFkInnPJvU4acV_FgwA-4=',
		'https://media.istockphoto.com/id/520410202/photo/silhouette-of-cross.jpg?s=612x612&w=0&k=20&c=3FQtiEuxhQ6FyCjRK-R6WMKmXv3viT2tzU4Wa73SDHY=',
		
		'https://cdn.pixabay.com/photo/2021/01/21/08/32/cross-5936587_640.jpg',
		'https://media.istockphoto.com/id/1505865534/photo/open-bible-on-a-wooden-board-near-the-river.jpg?s=612x612&w=0&k=20&c=UgpzuJyucoy_6RoUGJalYa1bO_Of4lD9YSc8FNciRSQ=',
		'https://media.istockphoto.com/id/875999648/photo/i-just-have-to-go-back-to-the-previous-page.jpg?s=612x612&w=0&k=20&c=32xTEBU6-0xaLy7LhUNMLSXMiapvYncOSsRv5WuzUh0=',
		'https://media.istockphoto.com/id/1398229185/photo/sky-and-clouds-holy-cross-of-jesus-christ-and-ray-of-bright-light.jpg?s=612x612&w=0&k=20&c=J_FYsJTpDOEUWnD6aq9KH0WBZzsALZRt0hmd4ciswcU=',
		'https://media.istockphoto.com/id/535889459/photo/open-bible.jpg?s=612x612&w=0&k=20&c=F1mFaxv5lA0kAXNzWogvPum-v3Td2Zz7UYCdrHvE1bM=',
		'https://media.istockphoto.com/id/1349828698/photo/woman-studying-at-outdoor-urban-cafe.jpg?s=612x612&w=0&k=20&c=Sha3cly4AXpDo36yiqU9x29OY8X0ZyPQ8A5F_NAvwy4=',
		'https://media.istockphoto.com/id/1425501371/photo/christian-boy-holds-bible-in-her-hands.jpg?s=612x612&w=0&k=20&c=gbsD64qf3NRLcCSIgD4m0u4Y4qRn-vdyh3fbR6IhP_g=',
		'https://media.istockphoto.com/id/1530192407/photo/christian-group-of-people-holding-hands-together-and-praying-on-the-holy-bible-devotional-for.jpg?s=612x612&w=0&k=20&c=X-s_cA0hrdlYeN0e44l3TdOCk-sOEfgK6iMHW__Yu9o=',
		'https://media.istockphoto.com/id/1140590681/photo/pretty-young-woman-sitting-next-to-tree-and-holding-bible.jpg?s=612x612&w=0&k=20&c=qwoJfF5JIjBIDZL3GpsqOm6aV3cre7Q24mgv6IocMoo=',
		'https://media.istockphoto.com/id/817603894/photo/bible.jpg?s=612x612&w=0&k=20&c=aSDchO8CEZCYvzJ1ZEVi-SNt5x50kClWMtlUGbOLOsk=',
		'https://media.istockphoto.com/id/1333229217/photo/close-up-of-open-holy-bible-with-a-bouquet-of-flowers-on-wooden-table-christian-background.jpg?s=612x612&w=0&k=20&c=iw1xV3-slYaOTSwYkFfiSyEOyXm744ZRGedb2MX-8To=',
		'https://media.istockphoto.com/id/1277520324/photo/a-young-woman-in-prayer-under-dramatic-light.jpg?s=612x612&w=0&k=20&c=zJyI-JsfV078ZW2OAlShTKVXyubjosWY0JUs0zK21VI=',
		'https://media.istockphoto.com/id/498338498/photo/woman-with-bible.jpg?s=612x612&w=0&k=20&c=4gBfOgQ2WcLmA0NWTJACYi_0k1x1VDA6bVEg8u2dfwU=',
		'https://media.istockphoto.com/id/1278490310/photo/worship-god-concept.jpg?s=612x612&w=0&k=20&c=vQFWRUryDjxWU_XVArCnlzsSeD0lA7HoVEBLswGgbWA=',
		'https://media.istockphoto.com/id/1393761729/photo/christian-bible-study-concepts-christian-friends-groups-read-and-study-the-bible-together-in.jpg?s=612x612&w=0&k=20&c=TrQ5AjAP-adoyrfBQYMNW485n6_u42XSxr5AlgYWAOk=',
		'https://cdn.pixabay.com/photo/2017/01/21/07/45/cross-1996530_640.jpg',
		'https://cdn.pixabay.com/photo/2024/05/07/04/40/ai-generated-8744766_640.jpg',
		'https://cdn.pixabay.com/photo/2019/03/18/12/09/cross-4062996_640.jpg',
		'https://media.istockphoto.com/id/495538268/photo/woman-with-bible.jpg?s=612x612&w=0&k=20&c=OJRDNZK2mi2C_eYyQsFGJlb4upTkqykZlC_izLefibg=',
		'https://media.istockphoto.com/id/889037644/photo/a-young-father-with-his-little-daughter-reads-the-bible.jpg?s=612x612&w=0&k=20&c=XqdWH6x3aNLVYGiNt2baLx20UAZ-p667E1MYAUVM5dI=',
		'https://media.istockphoto.com/id/1456438449/photo/woman-praying-with-the-bible-on-the-table.jpg?s=612x612&w=0&k=20&c=0Qz-BhXdFixPbOWbDPP_HyFb4aW_neFFYtDIwrZF9CE=',
		'https://media.istockphoto.com/id/1533925326/photo/enchanted-magic-open-book-on-rocky-beach-at-sunset-glow-light.jpg?s=612x612&w=0&k=20&c=WEg2okmGtoM5sUDQjZW0oOtZ9d_BKpqIkr9M6bAOX8s=',
		'https://cdn.pixabay.com/photo/2020/07/11/13/01/mountain-cross-5393958_640.jpg',
		'https://media.istockphoto.com/id/1262595788/photo/close-up-of-man-hands-praying-on-bible.jpg?s=612x612&w=0&k=20&c=gocB0iMgONsrVz15E7kjy6ndqYFLpKbDVDbLh8XUldI=',
		'https://media.istockphoto.com/id/1249125099/photo/person-side-view-asian-women-sad-broken-heart-and-depressed.jpg?s=612x612&w=0&k=20&c=cymN2fhEWv17PCzNwni1AJqCgoCWEnh6tKN2HMgM-Tg=',
		'https://media.istockphoto.com/id/1307343584/photo/a-girl-sits-in-a-field-on-a-lawn-of-yellow-flowers-reading-a-book-on-a-summer-sunny-day-a.jpg?s=612x612&w=0&k=20&c=lZSNrXlUR7Dps3uB56EZj8MT0S8VAXL6FkyjqCMqv70=',
		'https://cdn.pixabay.com/photo/2021/10/19/14/22/island-6723723_640.jpg',
		'https://cdn.pixabay.com/photo/2019/03/17/07/38/sunset-4060429_640.jpg',
		'https://cdn.pixabay.com/photo/2013/07/12/15/06/catholic-149432_640.png',
		'https://media.istockphoto.com/id/842379598/photo/bible-and-cross-on-desk.jpg?s=612x612&w=0&k=20&c=08Hkeaa1rA4L2h0VU1v-2HNuoxY5QzUqTDsgKEP-2Jw=',
		'https://media.istockphoto.com/id/481795692/photo/first-light-cross.jpg?s=612x612&w=0&k=20&c=fEFDdgS9S6L2N6jsJhc0VH3Ov3eZaxmjzh15ev_fMe8=',
		'https://cdn.pixabay.com/photo/2017/05/10/15/05/gmunden-2301046_640.jpg',
		'https://cdn.pixabay.com/photo/2017/02/06/18/56/cross-2043874_640.jpg',
		'https://media.istockphoto.com/id/1414832153/photo/christian-friends-group-reading-and-study-bible-together-in-home-or-sunday-school-at-church.jpg?s=612x612&w=0&k=20&c=zcoxYCenSw5Rxa7U76kqYAjzBPAVhtBgIUi2Kl62WY0=',
		'https://media.istockphoto.com/id/110825442/photo/relaxing-and-reading-bible-by-candlelight-at-night.jpg?s=612x612&w=0&k=20&c=593UdizMvFlBWSBepjoxYUBW56w6o-wpHrVVuo9LCUE=',
		'https://cdn.pixabay.com/photo/2016/06/10/21/43/cross-1448946_640.jpg',
		'https://media.istockphoto.com/id/687170006/photo/bible.jpg?s=612x612&w=0&k=20&c=05k7vUB8SiJTU0G_c76AFX5MAZNcH2vzbuDOnGh7E18=',
		'https://media.istockphoto.com/id/1425242522/photo/a-christian-praying-while-looking-at-the-setting-sun-and-the-holy-bible.jpg?s=612x612&w=0&k=20&c=X40GqA9BVjoKlSPwZqCKXJzpm6UZoCNaV0t86gb84jk=',
		'https://cdn.pixabay.com/photo/2018/08/30/18/42/cross-3643027_640.jpg',
		'https://media.istockphoto.com/id/1403433539/photo/girl-with-the-bible-in-nature-beautiful-christian-picture.jpg?s=612x612&w=0&k=20&c=eDqX2J8YcoN8D-nitgFiW-jkxkgFvON_SXpcXOz6v-4=',
		'https://media.istockphoto.com/id/1349092363/photo/christian-man-sit-holds-the-bible-in-hands-to-reading-the-holy-bible-and-pray-in-a-field.jpg?s=612x612&w=0&k=20&c=H_Q847NY_ih8EUb_MldsvSKJNYOfelMtthw6OBfdGTQ=',
		'https://cdn.pixabay.com/photo/2015/04/11/11/44/jesus-717623_640.jpg',
		'https://media.istockphoto.com/id/1015855272/photo/image-of-open-antique-book-on-wooden-table-with-glitter-background.jpg?s=612x612&w=0&k=20&c=qwhgLXoKhZfEnzTyI8knu7mPsyfQ5PyYaGUlYOmsHv8=',
		'https://media.istockphoto.com/id/1497058759/photo/silhouette-of-the-cross-at-sunset-symbol-of-christian-christian-concept.jpg?s=612x612&w=0&k=20&c=tWVvtHC5j4GRlX88T74_dzhKLud8YUItKHbyxAzJJkU=',
		'https://media.istockphoto.com/id/1496842238/photo/christian-couple-or-group-reading-study-the-bible-together-and-pray-at-a-home-or-sunday.jpg?s=612x612&w=0&k=20&c=1nuKa6x7EDqQfS0DHfplY2mBkFXnJTXqxZNinCyNz7g=',
		'https://media.istockphoto.com/id/937796756/photo/a-small-girl-praying-at-home.jpg?s=612x612&w=0&k=20&c=Z7TfS9ePrjFB2xwvmPN0FfxZCPRR2V5pRnWibja6mjM=',
		'https://media.istockphoto.com/id/1805813655/photo/christian-hand-presenting-a-holy-bible-and-church-evangelism-concept-spreading-the-gospel-and.jpg?s=612x612&w=0&k=20&c=mKfvPw-vx8q7Mo8QlF3bo4waMH_TxzdwnODyLyhxbOE=',
		'https://media.istockphoto.com/id/1016014390/photo/open-book-biblia.jpg?s=612x612&w=0&k=20&c=eOfeZEcvo6Fd3XcrwUw42jTAKHlIuMjY2PTvdP-a1xU=',
		'https://media.istockphoto.com/id/1331574354/photo/closeup-of-simple-wooden-christian-cross-necklace-on-old-bible-christian-background-with-copy.jpg?s=612x612&w=0&k=20&c=__6PAPz144l9WJCwDszf00SbUz-dEn36s9u-94LZJEU=',
		'https://cdn.pixabay.com/photo/2014/05/23/04/04/cross-351705_640.jpg',
		'https://media.istockphoto.com/id/1412637153/photo/magic-book-with-open-pages-and-abstract-lights-shining-in-darkness-literature-and-fairytale.jpg?s=612x612&w=0&k=20&c=rc3Bh74ePX8QPGnOi5oeEYOwFaJYsseXu8A0dGFqRzI=',
		'https://media.istockphoto.com/id/1494586285/photo/bible-prayer-and-black-woman-praying-on-bed-in-bedroom-home-for-hope-help-or-spiritual-faith.jpg?s=612x612&w=0&k=20&c=TGnWfDZ1QAV0aq2bImPIOI-YoSMYvu0SYf_wgjuA-mM=',
	    'https://media.istockphoto.com/id/1333029643/photo/sunset-in-the-forest-and-the-cross-of-the-tree.jpg?s=612x612&w=0&k=20&c=2t2mJVrBYsDQFYaGVABYfFWvldpK-BuBgebEl9ClPwU=',
		'https://media.istockphoto.com/id/1464009303/photo/wooden-cross-against-orange-sunrise.jpg?s=612x612&w=0&k=20&c=gCiIqeyvk_p0tA-RaBlIwkVJJqE-3i6gR_rrgYlV0NM=',
		'https://media.istockphoto.com/id/495205002/photo/friends-reading-the-bible-together.jpg?s=612x612&w=0&k=20&c=7udBh0QzfBFdohIq3MEvxA_1AnR6I-pJu9VaZZ7jvv4=',
		'https://media.istockphoto.com/id/1360520573/photo/christian-group-of-people-holding-hands-praying-worship-to-believe-and-bible-on-a-wooden.jpg?s=612x612&w=0&k=20&c=vDtw5TLEdnK-UG1OypFWyVJPWOTVxk6ycQsTBXgQk_c=',
		'https://media.istockphoto.com/id/846190258/photo/an-opened-bible-on-a-table-in-a-green-garden.jpg?s=612x612&w=0&k=20&c=jlHUPdqqgbdoKuHI5MvLXl8TuAKX8LLbnEiW1rn8gL0=',
		'https://media.istockphoto.com/id/1414832151/photo/woman-hands-praying-with-a-bible-in-his-legs-outdoors.jpg?s=612x612&w=0&k=20&c=gVva9xiI7Iknk_MnMTMRa469-azWwIff7KRU7CkFtK8=',
		'https://cdn.pixabay.com/photo/2016/06/08/07/28/easter-1443348_640.jpg',
		'https://media.istockphoto.com/id/1304670902/photo/cross.jpg?s=612x612&w=0&k=20&c=bsPwXoXPoH5JrQ9uIYREdxmgC2tTQuTfVlXcSdrQ1mQ=',
		'https://media.istockphoto.com/id/1390586505/photo/image-of-open-antique-book-on-wooden-table-with-vintage-key.jpg?s=612x612&w=0&k=20&c=8GJ7rJVYfPKgrdPqR8Q9YP348yVEVlkedvcW6BjGx5A=',
		'https://media.istockphoto.com/id/1209689579/photo/hands-folded-in-prayer-on-a-holy-bible-in-church-concept-for-faith.jpg?s=612x612&w=0&k=20&c=HtuWDpeDKt-CqW95Vtxr7Ny4QAVgrJq2LbxyTe8kmDE=',
		'https://media.istockphoto.com/id/1341061126/photo/man-praying-on-the-holy-bible-in-a-field-during-beautiful-sunset-male-sitting-with-closed.jpg?s=612x612&w=0&k=20&c=XNfhHMrWWzbL-qXMB_nXX8c6X8pLv_uSZ2r_QE-nYnk=',
		'https://media.istockphoto.com/id/1162961998/photo/christian-teenage-girl-holds-bible-in-her-hands-reading-the-holy-bible-in-a-field-during.jpg?s=612x612&w=0&k=20&c=a0GTj2OKZexGDsITUIiCVF7T9TQ643UJ8fNiTa-bzyU=',
		'https://media.istockphoto.com/id/530660615/photo/woman-reading.jpg?s=612x612&w=0&k=20&c=JvBaluMu80OPahO97AdPrbvTtgno9dc_oKh25nVMxEo=',
		'https://media.istockphoto.com/id/1464383776/photo/resurrected-jesus-christ-ascending-above-the-sky-and-clouds-heaven-concept.jpg?s=612x612&w=0&k=20&c=IIQ-5QJWSk8RGrseeVQhy7pEmXEWN1SzxWeXune-9-k=',
		'https://media.istockphoto.com/id/1410771971/photo/candle-with-bible-on-a-old-oak-wooden-table.jpg?s=612x612&w=0&k=20&c=gZm3LzMQiZyWwB4m8iTegT5hGAW_FJ4ROhmQWDcUSvk=',
		'https://media.istockphoto.com/id/1163290205/vector/mystery-open-book-with-shining-pages-fantasy-book-with-magic-light-sparkles-and-stars-vector.jpg?s=612x612&w=0&k=20&c=okeOBDxNAw9wx-dM5CQoVtzu7XKzd7gyZqd7wuW8bQU=',
		'https://media.istockphoto.com/id/938471864/photo/cross.jpg?s=612x612&w=0&k=20&c=mMBaH51R1FnbbxWh1eAjwk6RfpF0wMgQ6MzlWbnljCM=',
		
		'https://media.istockphoto.com/id/516137066/photo/magic-book-with-shining-lights.jpg?s=612x612&w=0&k=20&c=wmRWM6MWdGn_6cmPxDfMXtWM-xZTB6fb-o6foGEQzbw=',
		'https://media.istockphoto.com/id/1283134933/photo/silhouette-cross-on-at-sunset-background.jpg?s=612x612&w=0&k=20&c=WhBz3XgEyJ8rOOHnuq3O4RfzICYjpK9aP2_9XiDzAZg=',
		'https://media.istockphoto.com/id/491329561/photo/young-girl-studying-her-bible-by-the-sea.jpg?s=612x612&w=0&k=20&c=OC9WVhVo2LkiZVxQAsR43dP_V3WfNLWyr8flKoL9XQI=',
		'https://media.istockphoto.com/id/180755664/photo/young-woman-reading-bible.jpg?s=612x612&w=0&k=20&c=3JbjO2_nO701NgjbYN8hCpvHc0OccAfq_QDfPIg7TNY=',
		'https://media.istockphoto.com/id/1262760635/photo/woman-reading-the-bible.jpg?s=612x612&w=0&k=20&c=FBHgzNMTvIPoOTTFBPHcUYQ3MXdydZCTNpKzYYM5l2o=',
		'https://cdn.pixabay.com/photo/2015/01/24/16/15/tyrol-610312_640.jpg',
		
		'https://media.istockphoto.com/id/1398059877/photo/christian-life-faith-hope-trust-in-god.jpg?s=612x612&w=0&k=20&c=SLyBt-fU6DQEREEpoSI77O7mSM7IPlt9TY5wHszfP7E=',
		'https://media.istockphoto.com/id/520135495/photo/jesus-christ-extending-welcoming-hand.jpg?s=612x612&w=0&k=20&c=S-DQ89OOTn0ni2bYo31XQ9wyUBNqgc3KzElZxz1f4K0=',
		'https://media.istockphoto.com/id/1467854088/photo/christian-cross-with-open-book-on-the-blue-sky.jpg?s=612x612&w=0&k=20&c=EoLfuaZ8ekjo9AH3gs7FwBp5s-Fv4wNavynwXsc20BY=',
		'https://media.istockphoto.com/id/1398229095/photo/shining-holy-cross-of-jesus-christ-and-bible.jpg?s=612x612&w=0&k=20&c=6ivsnvRVsGTvBV3DaZp7RRRbmd-Mg7adAjJAXSVNErY=',
		'https://media.istockphoto.com/id/1221850781/photo/the-bible.jpg?s=612x612&w=0&k=20&c=lWPxpz26VUMfzivHW2REjPoRaYiuzMF16q3_fyy36rQ=',
		'https://cdn.pixabay.com/photo/2021/10/12/13/46/cross-6703536_640.jpg',
		'https://media.istockphoto.com/id/470963534/photo/cross-silhouette-with-the-sunset-as-background.jpg?s=612x612&w=0&k=20&c=NS6fMtwyJC9X6nyu8W5G9MX_o-A2X3x7nn-hlWxGXdY=',
		'https://cdn.pixabay.com/photo/2024/08/14/12/19/ai-generated-8968433_640.jpg',
		'https://media.istockphoto.com/id/104314531/photo/reading-the-bible.jpg?s=612x612&w=0&k=20&c=buPNND8FuSYOIfyulQtVMG4z9jD-m63bxq_zd0taeS4=',
		'https://cdn.pixabay.com/photo/2016/10/26/20/28/cross-1772560_640.jpg',
		'https://cdn.pixabay.com/photo/2017/09/23/04/25/sea-2777839_640.jpg',
		'https://media.istockphoto.com/id/1171955147/photo/little-asian-girl-pray-with-bible-in-classroom-at-school-bible-study-concept.jpg?s=612x612&w=0&k=20&c=0NhDmVICo5kSgJRoUwPR6TEyXoHOkNIo6MzLqFkCaqI=',
		'https://media.istockphoto.com/id/1404564415/photo/hands-folded-in-prayer-on-a-holy-bible-in-church-concept-for-faith-spirituality-and-religion.jpg?s=612x612&w=0&k=20&c=HeoajJMGRKse7WMCBfwAaUZ31AI7Y2VQZVD3uKp-nCU=',
		'https://media.istockphoto.com/id/1451537249/photo/bible-on-retro-wood-background.jpg?s=612x612&w=0&k=20&c=VtzbfCUaDzB90_DocFS6o3NDh1uuD2Mw6e_qSKncZI0=',
		'https://media.istockphoto.com/id/873507500/photo/image-of-open-antique-book-on-wooden-table-with-glitter-overlay.jpg?s=612x612&w=0&k=20&c=clB-tJl5j44IqVLlCELHVP6G-kJjeNt_nNmQi48aEKo=',
		'https://media.istockphoto.com/id/1297292626/photo/young-woman-pray-with-bible-relationship-with-god-at-home.jpg?s=612x612&w=0&k=20&c=mj7dXxelit5z7BKSXSdRvJcEoHkd4m2-jqkOHH-EtT4=',
		'https://media.istockphoto.com/id/1041747468/photo/theres-so-much-to-learn.jpg?s=612x612&w=0&k=20&c=l7W6hkO0aMFpbd-Kqa5vMGeyOiuabKnliOgYpwga39A=',
		'https://media.istockphoto.com/id/1251957675/photo/shining-holy-bible-ancient-book-on-old-table.jpg?s=612x612&w=0&k=20&c=TkKlW1rvcxHRrkteQ0wIFVSdIA46aZMvZeZWuTx8gGg=',
		'https://media.istockphoto.com/id/1391891492/photo/two-christianity-sitting-around-wooden-table-with-studying-the-bible-and-praying-to-god.jpg?s=612x612&w=0&k=20&c=y3gxYYuWF6HJ6bNnp3MC7oWegubD2cSL2JCWVQW4Jyw=',
		'https://media.istockphoto.com/id/875444756/photo/the-right-path.jpg?s=612x612&w=0&k=20&c=6Az3jaQCoPnmyYbZf1ixQ23QQ9hxs0_4ostlIL09paE=',
		'https://media.istockphoto.com/id/1407966525/photo/wooden-cross-at-sunset.jpg?s=612x612&w=0&k=20&c=7i724R1JJb121E17v1oWwkOW5qVDGKc6IFcQ6WdznME=',
		'https://media.istockphoto.com/id/1333233449/photo/close-up-of-a-man-holding-holy-bible-with-star-and-bokeh-light-effected-on-wood-table.jpg?s=612x612&w=0&k=20&c=FdaQjuBxXqGCaIt6sEVQG7sH-K7iagP2YvYvS7lguEE=',
		'https://media.istockphoto.com/id/1937291618/photo/woman-hands-praying-to-god-with-the-bible-begging-for-forgiveness-and-believe-in-goodness.jpg?s=612x612&w=0&k=20&c=ZliMp9zyNh4aEr8eHSuwNP6ca-_o2-SmruRfBU7z48w=',
		'https://media.istockphoto.com/id/494612492/photo/praying-together-in-calass.jpg?s=612x612&w=0&k=20&c=c-3qmkVcoYOulF1fXh5mQOnSj01na7r4NMJrdbIR7QY=',
		'https://media.istockphoto.com/id/1316557542/photo/hands-of-praying-young-man-and-bible-on-a-wooden-desk-background-man-join-hands-to-pray-and.jpg?s=612x612&w=0&k=20&c=1Lee2i6mCyLziLMtzSK9yKfq_VWvYqFcm4DA64g88SU=',
		'https://media.istockphoto.com/id/1435990180/photo/worship-christian-with-bible-concept-young-boy-person-hand-holding-holy-bible-with-study-at.jpg?s=612x612&w=0&k=20&c=NBD_gnHlTVQEi1qHsX0h-jQQ1B0T6cPikKt8FCOYzE0=',
		'https://media.istockphoto.com/id/924084058/photo/a-small-girl-and-grandmother-reading-bible-at-home.jpg?s=612x612&w=0&k=20&c=4yiQh8O0CUnKo4rFKj-MkbZDlM6_tDVNRtPkIpT_E0c=',
		'https://media.istockphoto.com/id/1483125627/photo/christian-illustration-of-a-girl-holding-an-open-bible-against-a-forest-backdrop.jpg?s=612x612&w=0&k=20&c=hxrIXfVxJTuY5huKt0A0DUnXcLUj7WjtNGO1nWYsXNA=',
		'https://media.istockphoto.com/id/474127794/photo/woman-finger-presses-on-bible-book.jpg?s=612x612&w=0&k=20&c=UUK0C_rqb7P8YbjyGSsxJihGeTRCQo9HI15iYcffQ1I=',
		'https://cdn.pixabay.com/photo/2023/08/24/11/59/cross-8210600_640.jpg',
		'https://media.istockphoto.com/id/1175079439/photo/cross.jpg?s=612x612&w=0&k=20&c=OpAyXV-r2TEbGksp51Fn0tiyrLqRMsdVgpEEtrP_d6o=',
		'https://media.istockphoto.com/id/1126378807/photo/african-american-man-praying-and-reading-the-bible.jpg?s=612x612&w=0&k=20&c=HRWm0pqWi7kKlCaRqASyocero0ryTu_EAXepufh5sgE=',
		'https://media.istockphoto.com/id/1282155342/photo/a-kid-reading-the-holy-bible.jpg?s=612x612&w=0&k=20&c=pYZWRizXA8Dylj85PiucyMBxVeIGFGkZbU-2VwtZMh4=',
		'https://media.istockphoto.com/id/1389600749/photo/woman-reading-holy-bible.jpg?s=612x612&w=0&k=20&c=MluU2qJVoDVHAm2NdJbP4vtzSFDx0c_V6lE5ojlwUT0=',
		'https://media.istockphoto.com/id/929067204/photo/multi-ethnic-mixed-age-bible-study-group.jpg?s=612x612&w=0&k=20&c=43maozRUWuQmYWgt-dEG8wWiMmaLGE3mTkcBnUtc09w=',
		'https://media.istockphoto.com/id/1623667885/photo/open-bible-on-a-wooden-board-near-the-river.jpg?s=612x612&w=0&k=20&c=GomKxytzUnA610DbCAjMFJ5Abc-9UdRKqESxkD_DdR8=',
		'https://media.istockphoto.com/id/1268696253/photo/girl-holds-bible-in-her-hands-reading-the-holy-bible-in-a-field-concept-for-faith.jpg?s=612x612&w=0&k=20&c=TewUrB1uNeJ0hCsEOB8H9kU4cYAg4hSQkt8NiKFdzt0=',
		'https://cdn.pixabay.com/photo/2015/01/24/16/15/tyrol-610312_640.jpg',
		'https://media.istockphoto.com/id/1404564416/photo/open-bible-on-a-slate-tabletop-with-customizable-space-to-add-text.jpg?s=612x612&w=0&k=20&c=1OtiyUxIlZfRZBuLvsfgQEeQCU04KEJuUgybwQ8NnSk=',
		'https://media.istockphoto.com/id/1438405694/photo/sunset-reed-barley-field-and-christian-holding-a-bible.jpg?s=612x612&w=0&k=20&c=sViVtk-MbuEuSC7VOssbHGy1OdQQforUcUqXMF3pCAg=',
        );

        $image_url = $image_urls[array_rand($image_urls)];
        $post = get_post($post_id);
        $title = $post->post_title;

        // Remove all before and after the first digit, leaving only alphabetic characters after the digit
        $filtered_title = preg_replace('/^.*\d+[^a-zA-Z]*([a-zA-Z].*)$/', '$1', $title);

        $upload_dir = wp_upload_dir();
        $image_filename = sanitize_file_name($filtered_title) . '.webp';
        $image_path = $upload_dir['path'] . '/' . $image_filename;
        $image_size = array(640, 400);

        $response = wp_remote_get($image_url);
        $body = wp_remote_retrieve_body($response);
        file_put_contents($image_path, $body);

        $image = imagecreatetruecolor($image_size[0], $image_size[1]);
        $source_image = imagecreatefromjpeg($image_path);
        $source_width = imagesx($source_image);
        $source_height = imagesy($source_image);
        $destination_width = $image_size[0];
        $destination_height = $image_size[1];
        $destination_x = 0;
        $destination_y = 0;
        imagecopyresampled($image, $source_image, $destination_x, $destination_y, 0, 0, $destination_width, $destination_height, $source_width, $source_height);

        $font_url = 'https://fonts.googleapis.com/css2?family=Bree+Serif&display=swap';
        $font_file = 'bree-serif.ttf';
        $font_path = $upload_dir['path'] . '/' . $font_file;
        if (!file_exists($font_path)) {
            $font_css = wp_remote_get($font_url);
            $font_css_body = wp_remote_retrieve_body($font_css);
            preg_match('/url\(([^)]+)\)/', $font_css_body, $matches);
            $font_file_url = $matches[1];
            $font_file_response = wp_remote_get($font_file_url);
            $font_file_body = wp_remote_retrieve_body($font_file_response);
            file_put_contents($font_path, $font_file_body);
        }

        $text_background_color = imagecolorallocatealpha($image, 249, 249, 249, 30); // rgba(249, 249, 249, 0.76)
        imagefilledrectangle($image, 50, 240, 590, 365, $text_background_color);

        // Get the user-selected text color from the settings
        $text_color_hex = get_option('afi_text_color', '#0400b7');
        list($r, $g, $b) = sscanf($text_color_hex, "#%02x%02x%02x");

        // Create the text color with the selected color
        $text_color = imagecolorallocate($image, $r, $g, $b);
        $font_size = 24;

        $text_box_width = 540;
        $text_box_height = 150;
        $padding_x = 20;
        $padding_y = 20;
        $line_height = 40;

        $wrapped_text = wordwrap($filtered_title, 30, "\n", true);
        $text_lines = explode("\n", $wrapped_text);

        $total_text_height = count($text_lines) * $line_height;
        $text_y = 240 + (($text_box_height - $total_text_height) / 2) + $padding_y;

        foreach ($text_lines as $index => $line) {
            $text_box = imagettfbbox($font_size, 0, $font_path, $line);
            $text_width = $text_box[2] - $text_box[0];
            $text_x = 50 + (($text_box_width - $text_width) / 2); // Center text within the box
            $text_y_line = $text_y + ($index * $line_height);
            imagettftext($image, $font_size, 0, $text_x, $text_y_line, $text_color, $font_path, $line);
        }

        imagewebp($image, $image_path, 80);
        imagedestroy($image);
        imagedestroy($source_image);

        $attachment_id = wp_insert_attachment(array(
            'guid' => $upload_dir['url'] . '/' . $image_filename,
            'post_mime_type' => 'image/webp',
            'post_title' => $filtered_title,
            'post_content' => '',
            'post_status' => 'inherit'
        ), $image_path, $post_id);

        require_once ABSPATH . 'wp-admin/includes/image.php';
        $attachment_data = wp_generate_attachment_metadata($attachment_id, $image_path);
        $attachment_data['width'] = $image_size[0];
        $attachment_data['height'] = $image_size[1];
        wp_update_attachment_metadata($attachment_id, $attachment_data);

        set_post_thumbnail($post_id, $attachment_id);
    }
}